
var ttt=10;

var items = [];
var curInd = -1;
var curLvl = -1;

var styles1=[], styles2=[];
var totalCnt1=0, totalCnt2=0;


function loadItems(its)
{
  clearItems();
  for (var i=0; i<its.length; i++)
      if (typeof(its[i])!='undefined') items[items.length] = its[i];
}


function getItemLevel(ind)
{
  if (ind==-1 || ind>=items.length) return -1;

  var lvl=0;
  while (items[ind][0].charAt(lvl)=='|') lvl++;
  return lvl;
}


function getParentItemInd(ind)
{
  var lvl=getItemLevel(ind);
  if (lvl<=0) return -1;
  
  ind--;
  while (getItemLevel(ind)>=lvl) ind--;
  
  return ind;
}


function getNextSiblingInd(ind)
{
  var lvl=getItemLevel(ind);
  ind++;
  while (ind<items.length && getItemLevel(ind)==lvl) ind++;

  return ind;
}


function getLastSiblingInd(ind)
{
  if (ind==items.length-1) return ind;           // check if specified item is the last item in menu

  var lvl=getItemLevel(ind);
  ind++;
  while (ind<items.length && getItemLevel(ind)==lvl) ind++;

  return ind;
}


function insertItem(ind, item)
{
  var i, its1=[], its2=[];
  for (i=0; i<ind; i++) its1[i] = items[i];
  for (i=ind; i<items.length; i++) its2[i-ind] = items[i];

  items = its1.concat(item).concat(its2);
}


function getItemChildrenCount(ind)
{
  var lvl = getItemLevel(ind+1);
  if (lvl!=-1 && lvl==getItemLevel(ind)+1)
      return getLastSiblingInd(ind+1)-ind;          // return children count
  else
      return 0;
}

function getItemAllChildrenCount(ind)
{
  ind++;
  var curLvl = getItemLevel(ind-1), lvl=getItemLevel(ind), cnt=0;
  while (lvl!=-1 && lvl>curLvl)
  {
      cnt++;
      ind++;
      lvl = getItemLevel(ind);
  }
  return cnt;
}


function strRepeat(cnt, c)
{
  var s='', i=0;
  while (i<cnt)
  {
      s += c;
      i++;
  }
  return s;
}


function addItem()
{
  var parentInd = getParentItemInd(curInd);
  if (parentInd==-1) items[items.length] = ["Menu Item"];
  else
  {
      insertItem(parentInd+getItemAllChildrenCount(parentInd)+1, [[strRepeat(getItemLevel(parentInd)+1, '|')+"Menu Subitem"]])
  }

  reCreateItemsList();
  parent.frames[4].window.startPreviewTimer();
}


function addSubitem()
{
  var lvl=getItemLevel(curInd);
  if (lvl==-1) return addItem();

  var childrenCnt = getItemChildrenCount(curInd);

  if (childrenCnt>0)
      insertItem(curInd+getItemAllChildrenCount(curInd)+1, [[strRepeat(lvl+1, '|')+"Menu Subitem"]])
  else
      insertItem(curInd+1, [[strRepeat(lvl+1, '|')+"Menu Subitem"]])

  reCreateItemsList();
  parent.frames[4].window.startPreviewTimer();
}


function checkParam(p, def)
{
  if (typeof(p)=='undefined' || p==null) return def;
  return p;
}


function selItem(selObj)
{
  if (selObj.selectedIndex==-1) return;
  
  curInd = selObj.selectedIndex;
  curLvl = getItemLevel(curInd);
  
  // Set item parameters in "Item Parameters" frame
  with (parent.frames[3].window)
  {
      dm_setItemParams(getItemText(curInd, false),
                       checkParam(items[curInd][1], ''),
                       checkParam(items[curInd][2], ''),
                       checkParam(items[curInd][3], ''),
                       checkParam(items[curInd][4], ''),
                       checkParam(items[curInd][5], ''),
                       checkParam(items[curInd][6], ''),
                       checkParam(items[curInd][7], ''),
                       checkParam(items[curInd][8], ''));

  }
}


function delSelected()
{
  if (!confirm('Delete selected items?')) return;

  var selObj = document.getElementById('itemsList');
  var its = [], delLvl = -1;

  for (var i=0; i<items.length; i++)
      if (selObj.options[i].selected || (delLvl!=-1 && getItemLevel(i)>delLvl))
      {
          selObj.options[i].selected = false;
          if (delLvl==-1) delLvl = getItemLevel(i);
      }
      else
      {
          if (getItemLevel(i)<=delLvl) delLvl=-1;
          its[its.length] = items[i];
      }

  items = its;
  reCreateItemsList();
  parent.frames[4].window.startPreviewTimer();
}


function clearItems()
{
  curInd = -1;
  items = [];
  with (document.getElementById('itemsList'))
      while (options.length>0) remove(0);
}


function delAll()
{
  if (!confirm('Delete all items?')) return;
  clearItems();
  parent.frames[4].window.startPreviewTimer();
}


function getItemText(ind, indent)
{
  var lvl = getItemLevel(ind);
  return (indent ? strRepeat(lvl*6, (b_IE ? ' ' : '-')) : '' ) + items[ind][0].substr(lvl, items[ind][0].length)
}


function reCreateItemsList()
{
  var opt, selObj=document.getElementById('itemsList');

  var i, cnt = items.length;

  var delCnt = selObj.options.length-cnt;
  for (i=0; i<delCnt; i++) selObj.remove(selObj.options.length-1);
  
  var len = selObj.options.length;
  for (i=0; i<len; i++) selObj.options[i].text = getItemText(i, true);

  for (i=len; i<items.length; i++)
  {
      opt = document.createElement('OPTION');
      opt.text = getItemText(i, true);
      if (b_IE)
          selObj.add(opt);
      else
          selObj.add(opt, null);
  }
}

//==============================================================================

function updateStylesLists(stylesType)
{
  parent.frames[3].window.dm_setIndividualStyles(stylesType, (stylesType ? styles2 : styles1 ));
  selItem(document.getElementById('itemsList'));
}


function addNewStyle2(stylesType)
{
  // Create new style in styles array
  var sName, lastInd;
  if (stylesType)
  {
      totalCnt2++;
      sName = 'Submenu Style ' + totalCnt2;
      lastInd = styles2.length;
      styles2[styles2.length] = [sName, '',''];
  }
  else
  {
      totalCnt1++;
      sName = 'Item Style ' + totalCnt1;
      lastInd = styles1.length;
      styles1[styles1.length] = [sName, '',''];
  }

  updateStylesLists(stylesType);

  return sName;
}


function deleteStyle2(stylesType, ind)
{
  var styles = stylesType ? styles2 : styles1;
  var sts = [];

  if (stylesType) styles2.splice(ind, 1);
             else styles1.splice(ind, 1);

  clearItemsStyle(stylesType, ind);
  updateStylesLists(stylesType);
}


function deleteAllStyles2(stylesType)
{
  // Create new style in styles array
  if (stylesType) styles2 = [];
             else styles1 = [];

  clearItemsStyle(stylesType, -1);               // clear style field for all items
  updateStylesLists(stylesType);
}


function duplicateStyle2(stylesType, ind)
{
  // Add new style and copy properties of specified style
  var sName;
  if (stylesType)
  {
      sName = styles2[ind][0] + ' copy';
      styles2[styles2.length] = [sName, styles2[ind][1], styles2[ind][2]];
  }
  else
  {
      sName = styles1[ind][0] + ' copy';
      styles1[styles1.length] = [sName, styles1[ind][1], styles1[ind][2]];
  }
  
  updateStylesLists(stylesType);

  return sName;
}


function changeStyleName2(stylesType, ind, newName)
{
  if (stylesType) styles2[ind][0] = newName;
             else styles1[ind][0] = newName;

  updateStylesLists(stylesType);
}


function updateStyleParameters2(stylesType, ind, paramsFrm)
// Updates parameters for selected individual style when one of parameters was changed
{
  if (stylesType)
  {
      styles2[ind][1] = paramsFrm.dm_getParamsList('');
      styles2[ind][2] = paramsFrm.dm_getStylesArray('');
  }
  else
  {
      styles1[ind][1] = paramsFrm.dm_getParamsList('');
      styles1[ind][2] = paramsFrm.dm_getStylesArray('');
  }
}


function clearItemsStyle(stylesType, styleInd)
// Removes specified style from all items
{
  var pInd = stylesType ? 7 : 6;                                     // get parameter index in item's record
  var curInd;

  for (var i=0; i<items.length; i++)
  {
      if (styleInd==-1) items[i][pInd] = null;                      // clear specified style field for all items
      else
      {
          if (typeof(items[i][pInd])!='undefined' && typeof(items[i][pInd])!=null)
              curInd = items[i][pInd];
          else
              curInd = -1;
              
          if (curInd==styleInd) items[i][pInd] = null;              // clear specified style index
          else
              if (curInd>styleInd) items[i][pInd] = curInd-1;       // decrease style indexes under specified index
      }
  }
}

//==============================================================================
//==============================================================================
//==============================================================================


function setChangedItemParam(paramInd)
{
  if (curInd!=-1)
  {
      items[curInd][paramInd] = parent.frames[3].window.dm_getItemParam(paramInd);

      // Changing item text
      if (paramInd==0)
          with (document.getElementById('itemsList').options[curInd])
          {
              items[curInd][0] = strRepeat(curLvl, '|') + items[curInd][0];
              text = getItemText(curInd, true);
              selected = true;
          }
          
      parent.frames[4].window.startPreviewTimer();
  }
}


function getMenuItemsData()
{
  var itemsData = 'var menuItems = [\n';
  for (var i=0; i<items.length; i++)
      itemsData += parent.frames[3].window.dm_getItemData('',
                                                          getItemLevel(i),
                                                          getItemText(i, false),
                                                          items[i][1],
                                                          items[i][2],
                                                          items[i][3],
                                                          items[i][4],
                                                          items[i][5],
                                                          items[i][6],
                                                          items[i][7],
                                                          items[i][8],
                                                          items[i][9],
                                                          items[i][10]) + ',\n';

  return itemsData + '];\n';
}


function getStylesData(stylesType)
{
  var styles = stylesType ? styles2 : styles1;
  if (!styles.length) return '';

  var stylesData = 'var ' + (stylesType ? 'menuStyles' : 'itemStyles') + ' = [\n';

  for (var i=0; i<styles.length; i++) stylesData += styles[i][2]+',\n';

  return stylesData + '];\n';
}


